<?php
/**
 * Header bar template part.
 *
 * 🚫🚫🚫
 * DO NOT EDIT THIS FILE WHILE INSIDE THE PLUGIN! Changes You make will be lost when a new version
 * of the AMP plugin is released. You need to copy this file out of the plugin and put it into your
 * custom theme, for example. To learn about how to customize these Reader-mode AMP templates, please
 * see: https://amp-wp.org/documentation/how-the-plugin-works/classic-templates/
 * 🚫🚫🚫
 *
 * @package AMP
 */

/**
 * Context.
 *
 * @var AMP_Post_Template $this
 */

?>
<?php
/** "AMP Header */
$header_nav_search_section    = 'yes';
$header_top_info_show         = 'no';
$amp_header_menu = '';
$amp_header_logo = QOXAG_IMG . '/logo.png';
 
if ( defined( 'DEVM' ) ) {
	$header_top_info_show = qoxag_option('amp_header_top_info_show');
	$amp_header_menu = qoxag_option( 'amp_header_menu' );
	$header_nav_search_section = qoxag_option( 'amp_header_nav_search_section' );
   $amp_header_logo = wp_get_attachment_image_src(qoxag_option( 'amp_header_logo'));
   if(!empty($amp_header_logo)){
      $amp_header_logo = $amp_header_logo['0'];
   } else {
      $amp_header_logo = QOXAG_IMG . '/logo.png'; 
   }
}

?>

<div class="header-main-container">
   <?php if(defined( 'DEVM' ) && $header_top_info_show=='yes' ): ?>
      <div class="container topbar">
         <ul class="top-info"><li><?php echo date('l '); ?> <?php echo date_i18n(get_option('date_format')); ?></li></ul>
         <?php
         $amp_facebook_link = qoxag_option('amp_facebook_link');
         $amp_twitter_link = qoxag_option('amp_twitter_link');
         $amp_instagram_link = qoxag_option('amp_instagram_link');
         $amp_linkedin_link = qoxag_option('amp_linkedin_link');         
         ?>
         <ul class="top-info social-icons">
         <?php if($amp_facebook_link != ''){ ?>
            <li><a href="<?php echo esc_url($amp_facebook_link); ?>" target="_blank"><i class="xts-icon xts-facebook"></i></a></li>
         <?php } ?>
         <?php if($amp_twitter_link != ''){ ?>
            <li><a href="<?php echo esc_url($amp_twitter_link); ?>" target="_blank"><i class="xts-icon xts-twitter"></i></a></li>
         <?php } ?>
         <?php if($amp_instagram_link != ''){ ?>
            <li><a href="<?php echo esc_url($amp_instagram_link); ?>" target="_blank"><i class="xts-icon xts-instagram"></i></a></li>
         <?php } ?>
         <?php if($amp_linkedin_link != ''){ ?>
            <li><a href="<?php echo esc_url($amp_linkedin_link); ?>" target="_blank"><i class="xts-icon xts-linkedin"></i></a></li>
         <?php } ?>
         </ul>
      <!-- end container -->
      </div>
   <?php endif; ?>

   <div class="header-middle-area header">
      <div class="container">
         <div class="logo-area">
            <a class="logo" href="<?php echo esc_url(home_url('/')); ?>">
               <img class="img-fluid" src="<?php echo esc_url($amp_header_logo); ?>" alt="<?php bloginfo('name'); ?>">
            </a>   
         </div>

		 <nav class="navbar navbar-expand-lg navbar-light">
			<div role="button" on="tap:sidebar.toggle" tabindex="0" class="hamburger">
				<button class="elementskit-menu-hamburger elementskit-menu-toggler" type="button" data-toggle="collapse" data-target="#primary-nav" aria-controls="primary-nav" aria-expanded="false"
					aria-label="Toggle navigation">
					<span class="elementskit-menu-hamburger-icon"></span>
					<span class="elementskit-menu-hamburger-icon"></span>
					<span class="elementskit-menu-hamburger-icon"></span>
				</button>
			</div>
		<!-- Site search end-->             
		</nav>

      </div>                     
   </div>
</div>

<amp-sidebar class="amp-menu-slide" id="sidebar" layout="nodisplay" side="left">
   <div on="tap:sidebar.close" class="menu-close" role="button" tabindex="0"><span class="icon-close">&times;</span></div>
      <div class="logo-area">
         <a class="logo" href="<?php echo esc_url(home_url('/')); ?>">
            <img class="img-fluid" src="<?php echo esc_url($amp_header_logo); ?>" alt="<?php bloginfo('name'); ?>">
         </a>
      </div>

      <?php 
      wp_nav_menu([
         'menu'            => $amp_header_menu,
         'menu_id'         => 'amp-menu',				  
         'container_id'    => 'amp-nav',
         'container'       => 'div',
         'container_class' => 'sidebar',
         'menu_class'      => 'amp-nav',
         'depth'           => 3,
         'fallback_cb'     => false,
      ]);
      ?>
</amp-sidebar>
